/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.codehaus.jettison.json.JSONObject;

public class VueCompiler {
    private String inputFilePath;
    private String outputFilePath;
    private String name = "";
    private String props = "";
    private String template = "";

    public static void main(String ... arguments) {
        VueCompiler vueCompiler = new VueCompiler(arguments);
        try {
            vueCompiler.compile();
        }
        catch (Throwable t) {
            System.err.println("Unexpected error:");
            t.printStackTrace();
            System.exit(-1);
        }
    }

    public VueCompiler(String[] arguments) {
        this.parseArguments(arguments);
    }

    private void parseArguments(String[] arguments) {
        try {
            this.inputFilePath = arguments[0];
            this.outputFilePath = arguments[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Two arguments expected: '<path to input file> <path to output file>'");
            System.exit(-1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compile() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.inputFilePath));
                try {
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFilePath));){
                        this.parseLines(reader);
                        this.writeLines(writer);
                    }
                    if (reader == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + this.inputFilePath);
            System.exit(-1);
        }
    }

    private void parseLines(BufferedReader reader) throws IOException {
        String line;
        int i = 1;
        while ((line = reader.readLine()) != null) {
            if (i == 1) {
                this.name = line.trim();
            } else if (i == 2) {
                this.props = line.trim();
            } else if (!line.trim().isEmpty()) {
                this.template = String.valueOf(this.template) + line.trim();
            }
            ++i;
        }
    }

    private void writeLines(BufferedWriter writer) throws IOException {
        writer.write(this.assembleComponentDefinitionLine());
        writer.write(this.assemblePropsLine());
        writer.write(this.assembleTemplateLine());
        writer.write(this.assembleTrailingLines());
    }

    private String assembleComponentDefinitionLine() {
        String prefix = "var ";
        String suffix = "Component = Vue.extend({\n";
        return String.valueOf(prefix) + this.name + suffix;
    }

    private String assemblePropsLine() {
        String prefix = "\tprops: ";
        String suffix = ",\n";
        return String.valueOf(prefix) + this.props + suffix;
    }

    private String assembleTemplateLine() {
        String prefix = "\ttemplate: ";
        return String.valueOf(prefix) + JSONObject.quote((String)this.template);
    }

    private String assembleTrailingLines() {
        String prefix = "\n});\n\nVue.component(\"";
        String infix = "\", ";
        String suffix = "Component);";
        return String.valueOf(prefix) + this.name + infix + this.name + suffix;
    }
}

